unit mVimmEditGrid;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mEditBase, rVimm,
  Vcl.ExtCtrls, Vcl.StdCtrls, uVimmEditObject, uEditObject, ORFn, mVimmGrid;

type
  TfraVimmEditGrid = class(TfraEditGridBase)
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
    vimmObjectIdx: integer;
    isEditing: boolean;
    dataStr: string;
    needsOverride: boolean;
    function validateAndBuild: boolean;

  public
     constructor Create(aOwner: TComponent); override;
     procedure setValues(data: string; edit, needsOverrideValue: boolean);
     procedure setAdditionalInputsParameter(inputs, defaultList: TStrings; layoutRequest: integer; isSaving: boolean); overload;
     procedure setInitialValues; override;
     procedure createLayout(inputList, defaultList: TStrings; layoutRequest: integer); override;
     procedure initilizeLookups;
    { Public declarations }
  end;


var
  fraVimmEditGrid: TfraVimmEditGrid;

implementation

{$R *.dfm}

{ TfraVimmEditGrid }

procedure TfraVimmEditGrid.btnSaveClick(Sender: TObject);
begin
  if validateAndBuild then
    clearGrid;
end;

constructor TfraVimmEditGrid.Create(aOwner: TComponent);
begin
  inherited;
end;

procedure TfraVimmEditGrid.createLayout(inputList, defaultList: TStrings;
  layoutRequest: integer);
var
colSize, i, rowSize: integer;
edtObject: vEditObject;
layoutControl: tLayoutControl;
editList: TStrings;
begin
  clearGrid;
  editList := TStringList.Create;
  if layout = nil then layout := TLayout.Create;
  Layout.layoutType := layoutRequest;
  try
    layout.buildlayout(inputList, defaultList);
    rowSize := 100 div self.layout.row;
    colSize := 100 div self.layout.column;
    grdEditPanel.RowCollection.BeginUpdate;
  // create row and size them
    for i := 0 to self.layout.row - 1 do
      begin
        grdEditPanel.RowCollection.Add;
        grdEditPanel.RowCollection[i].SizeStyle := ssPercent;
        grdEditPanel.RowCollection[i].Value := rowSize;
      end;
    grdEditPanel.RowCollection.EndUpdate;
  // create column and size them
    grdEditPanel.ColumnCollection.BeginUpdate;
    for i := 0 to self.layout.column - 1 do
      begin
        grdEditPanel.ColumnCollection.Add;
        grdEditPanel.ColumnCollection[i].SizeStyle := ssPercent;
        grdEditPanel.ColumnCollection[i].Value := colSize;
      end;
    grdEditPanel.ColumnCollection.EndUpdate;

    grdEditPanel.ControlCollection.BeginUpdate;
    for i := 0 to self.layout.controls.Count - 1 do
      begin
        layoutControl := tLayoutControl(self.layout.controls.Objects[i]);
        edtObject := vEditObject.create(layoutControl, self, grdEditPanel);
        layoutControl.uiControl := edtObject;
        edtObject.layout := layout;
        grdEditPanel.ControlCollection.AddControl(edtObject.editPanel, layoutControl.colNum, layoutControl.rowNum);
        grdEditPanel.ControlCollection[i].SetLocation(layoutControl.colNum, layoutControl.rowNum, false);
        grdEditPanel.ControlCollection[i].ColumnSpan := layoutControl.ColSpan;
      end;
    grdEditPanel.ControlCollection.EndUpdate;
//    setInitialValues;
  finally
    FreeAndNil(editList);
//    FreeAndNil(inputList);
  end;

end;

procedure TfraVimmEditGrid.initilizeLookups;
var
i: integer;
layoutControl: tLayoutControl;
editObject: vEditObject;
returnList: TStrings;
value: string;

begin
  for i := 0 to layout.controls.Count - 1 do
    begin
      layoutControl := tLayoutControl(layout.controls.Objects[i]);
      editObject := vEditObject(layoutControl.uiControl);
      if editObject.longList then
        begin
//          idx := -1;
           if editObject.name = 'ORDERING PROVIDER' then
            begin
              if editObject.extVal <> '' then value := editObject.extVal
              else value := uVimmInputs.encounterProviderName;
              populateProviderLookup(editObject, value);
            end
           else if editObject.name = 'ENCOUNTER PROVIDER' then
            begin
              if editObject.extVal <> '' then value := editObject.extVal
              else value := uVimmInputs.userName;
              populateProviderLookup(editObject, value);
            end;
        end
      else
        begin
          returnList := TStringList.Create;
          try
            editObject.populateComponent;
            editObject.setDefaultValue;
          finally
            FreeAndNil(returnList);
          end;

        end;
    end;
end;

procedure TfraVimmEditGrid.setAdditionalInputsParameter(inputs, defaultList: TStrings; layoutRequest: integer; isSaving: boolean);
var
vid: string;
dataResult : TVimmResult;
begin
  try
  if uVimmInputs.isSkinTest then inputs.Add('TYPE' + U + 'SKIN TEST')
  else inputs.Add('TYPE' + U + 'IMMUNIZATION');
   if isEditing and (not isSaving) then
      begin
        dataResult := getVimmResult(StrToIntDef(Piece(dataStr,U,1),-1));
        if dataResult <> nil then
          begin
            vimmObjectIdx := StrToIntDef(Piece(dataStr,U,1),-1);
            vid := dataResult.id;
            if dataResult.defaultDataList <> nil then FastAssign(dataResult.defaultDataList, defaultList);
            dataStr := dataResult.id + U + dataResult.name + U + dataResult.documType;
          end;
      end
    else
      begin
        vid := Piece(dataStr, U, 1);
        vimmObjectIdx := -1;
      end;
    inputs.Add('DOCUMENTTYPE' + U + IntToStr(layoutRequest));
    inputs.Add('NAME' + U + Piece(dataStr, u, 2));
    inputs.Add('ID' + U + vid);
    inputs.Add('DATETIME' + U + FloatToStr(uvimminputs.dateEncounterDateTime));
    inputs.Add('ENCOUNTERTYPE' + U + uvimmInputs.encounterCategory);
    inputs.Add('PATIENTID' + U + uVimmInputs.patientIEN);
    inputs.Add('VISITSTR' + U + uVimmInputs.visitString);
    if needsOverride then inputs.Add('NEEDSOVERRIDE' + U + '1')
    else inputs.Add('NEEDSOVERRIDE' + U + '0');;
  finally

  end;

end;

procedure TfraVimmEditGrid.setInitialValues;
begin
  initilizeLookups;
end;

procedure TfraVimmEditGrid.setValues(data: string; edit,
  needsOverrideValue: boolean);
begin
  dataStr := data;
  isEditing := edit;
  needsOverride := needsOverrideValue;
end;

function TfraVimmEditGrid.validateAndBuild: boolean;
var
compList, dataList, defaultList, inputList, layoutDefaultList, noteList, tempList, visList: TStrings;
idx, visIDX: integer;
adminDate, delimitedStr, delimitedStr2, delimitedStr3, int, temp: string;
data: TVimmResult;
grid: TGridPanel;
aControl: TControl;
begin
  inputList := TStringList.Create;
  compList := TStringList.Create;
  dataList := TStringList.Create;
  tempList := TStringList.Create;
  visList := TStringList.Create;
  defaultList := TStringList.Create;
  noteList := TStringList.Create;
  layoutDefaultList := TStringList.Create;
  try
    setAdditionalInputsParameter(inputList, defaultList ,layout.layoutType, true);
    result := layout.validateData(compList);
    if not result  then
      begin
        ShowMessage('A value for ' + compList.Strings[0] + ' is not defined.');
        exit;
      end;
    visIDX := -1;
  if not uVimmInputs.isSkinTest and (layout.layoutType = 0) then
    begin
      for idx := 0 to compList.Count - 1 do
        begin
          if Piece(compList.Strings[idx], U, 1) <> 'VIS OFFERED' then continue;
          temp := compList.Strings[idx];
          int := Piece(temp, U, 2);
          visIdx := idx;
          self.layout.returnComponentDataList('VIS OFFERED', tempList);
          buildVISString(dataStr, int, tempList, visList);
//          compList.Strings[idx] :=  'VIS OFFERED' + U + int + U + ext;
        end;
      if visIDX > -1 then
        begin
          compList.Delete(visIdx);
          for idx := 0 to visList.Count - 1 do
              compList.Add(visList.Strings[idx]);
        end;
    end;
  result := self.layout.validate(compList, inputList, dataList);
  if not result then
    begin
      ShowMessage(dataList.Strings[0]);
      exit;
    end;
  if Piece(dataList.Strings[0], u, 1) = '1' then adminDate := Piece(dataList.Strings[0], u, 2);
  for idx := 1 to dataList.Count - 1 do
    begin
      temp := dataList.Strings[idx];
      if Piece(temp, U, 1) = 'NOTE' then
        notelist.Add(Piece(temp, u, 2))
      else if Piece(temp, U, 1) = 'LAYOUT' then
        layoutDefaultList.Add(Pieces(temp, u, 2, 4))
      else if Piece(temp, U, 1) = 'DATA' then
        delimitedStr := Pieces(temp, u, 2, 30)
      else if Piece(temp, U, 1) = 'DATA1' then
        delimitedStr2 := Pieces(temp, u, 2, 4)
      else if Piece(temp, U, 1) = 'DATA2' then
        delimitedStr3 := Pieces(temp, u, 2, 4);
    end;
    if vimmObjectIdx > -1 then
      begin
        data := getVimmResult(vimmObjectIdx);
        data.DelimitedStr :=  delimitedStr;
        data.DelimitedStr2 := delimitedStr2;
        data.DelimitedStr3 := delimitedStr3;
      end
    else data := TVimmResult.Create(delimitedStr, delimitedStr2, delimitedStr3, false);
    data.adminDate := StrToFloatDef(adminDate, 0);
    if data.noteText = nil then data.noteText := TStringList.Create;
//    data.documType := '';
  if not uvimmInputs.isSkinTest then
    begin
      case layout.layoutType of
        0: data.documType := 'Administered';
        1: data.documType := 'Historical';
        2: data.documType := 'Contraindication';
        3: data.documType := 'Refused';
      end;
    end
  else
    begin
       case layout.layoutType of
        0: data.documType := 'Administered';
        1: data.documType := 'Reading';
        2: data.documType := 'Historical';
       end;
    end;
    FastAssign(noteList, data.noteText);
    FastAssign(layoutDefaultList, data.defaultDataList);
    idx := setVimmResults(data);
//  idx :=  StrToIntDef(temp,-1);
//  if idx = -1 then exit;
    result := true;
    grid := TGridPanel(self.Parent.Parent.Parent);
    aControl := grid.ControlCollection.Controls[0, 1];
    TfraGrid(aControl).updateGrid(idx);
  finally
    FreeAndNil(inputList);
    FreeAndNil(compList);
    FreeAndNil(dataList);
    FreeAndNil(tempList);
    FreeAndNil(visList);
    FreeAndNil(defaultList);
    FreeAndNil(layoutDefaultList);
    FreeAndNil(NoteList);
  end;
end;

end.
